﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private appService As PhoneApplicationService = PhoneApplicationService.Current
    Private smsTask As SmsComposeTask


    Public Sub New()
        InitializeComponent()

        smsTask = New SmsComposeTask()
    End Sub


    Private Sub OnTextBoxTextChanged(ByVal sender As Object, ByVal args As TextChangedEventArgs)
        If sender Is bodyTextBox Then
            charCountText.Text = String.Format("{0}/160", bodyTextBox.Text.Length)
        End If

        sendButton.IsEnabled = toTextBox.Text.Length > 0 AndAlso bodyTextBox.Text.Length > 0
    End Sub


    Private Sub OnSendButtonClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
        smsTask.To = toTextBox.Text
        smsTask.Body = bodyTextBox.Text
        smsTask.Show()
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        appService.State("toText") = toTextBox.Text
        appService.State("bodyText") = bodyTextBox.Text

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        Dim text = Nothing

        If appService.State.TryGetValue("toText", text) Then
            toTextBox.Text = TryCast(text, String)
        End If

        If appService.State.TryGetValue("bodyText", text) Then
            bodyTextBox.Text = TryCast(text, String)
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class